/////////////////////////////////////////////////////////////
//	File	:	"CBase.cpp"
//
//	Author	:	Sean Murray (SM)
//
//	Purpose	:	The base object for our class hierarchy
//				and implements our base interface.
/////////////////////////////////////////////////////////////
#include "CBase.h"
#include "CSGD_TextureManager.h"
#include "CGame.h"
#include "CSGD_MessageSystem.h"
#include "AnimInstance.h"
#include "CNote.h"

///////////////////////////////////////////////////////////////////////////////////
//  Function: Constructor
//
//  Purpose : Initializes the data in the object.
///////////////////////////////////////////////////////////////////////////////////
CBase::CBase(void)
{
	m_unRefCount = 1;	//	Start the refernce count at 1.

	SetImageID( -1 );	//	Default the image ID to -1 for error checking purposes.
	SetPosX( 0 );		//	Set the position and velocity to 0.
	SetPosY( 0 );
	SetVelX( 0 );
	SetVelY( 0 );
	SetScale(0);
	SetRotation(0);
	m_fZPosition = 0.5f;
	m_pCurrentAnim = new CAnimInstance();
	m_bIsAnimated = false;
}

///////////////////////////////////////////////////////////////////////////////////
//  Function: Destructor
//
//  Purpose : Cleans up any dynamic memory.
///////////////////////////////////////////////////////////////////////////////////
CBase::~CBase(void)
{
}

///////////////////////////////////////////////////////////////////////
//	Function:	GetCollisionRect
//
//	Purpose:	Gets the collision rect of the object based on its 
//				position and width/height.
///////////////////////////////////////////////////////////////////////
RECT CBase::GetCollisionRect()
{
	return m_rCollisionRect;
}

///////////////////////////////////////////////////////////////////////////////
//	Function:	"Update"
//
//	Purpose:	Updates the objects position based on its velocity
///////////////////////////////////////////////////////////////////////////////
void CBase::Update(float fElapsedTime)
{

	SetPosX( GetPosX() + (GetVelX() * fElapsedTime));	//	Update X position
	SetPosY( GetPosY() + (GetVelY() * fElapsedTime));	//	Update Y position

	if(GetPosX() < 0 || GetPosX() > CGame::GetInstance()->GetWidth() || GetPosY() < 0 || GetPosY() > CGame::GetInstance()->GetHeight())
	{
		CSGD_MessageSystem::GetInstance()->SendMsg( new CDestroyBulletMessage(this));
	}

	m_rCollisionRect.right = (long)(GetPosX() + GetWidth());
	m_rCollisionRect.bottom = (long)(GetPosY() + GetHeight());
	m_rCollisionRect.top = (long)GetPosY();
	m_rCollisionRect.left = (long)GetPosX();

	if(m_bIsAnimated)
		m_pCurrentAnim->Update(fElapsedTime);
	
}

///////////////////////////////////////////////////////////////////////////////
//	Function:	Render
//
//	Purpose:	Renders the object
///////////////////////////////////////////////////////////////////////////////
void CBase::Render(void)
{
	CSGD_TextureManager* pTM = CSGD_TextureManager::GetInstance();
	if(m_bIsAnimated)
		pTM->DrawTexture(CAnimationManager::GetInstance()->GetSpriteSheet(m_pCurrentAnim->GetSpriteFile())->GetImageID(), 
		GetPosX(), GetPosY(), 0.05f, GetScale(), GetScale(), &m_pCurrentAnim->GetCurrentFrameRect(), 0, 0, GetRotation());
	else
		pTM->DrawTexture(m_nImageID, GetPosX(), GetPosY(), m_fZPosition, GetScale(), GetScale(), 0, GetPosX() - GetWidth(), GetPosY() - GetHeight(), GetRotation());		//	Render the object based on its position
//
//	 //	////////////////////////////////////////////////////////////
//		//Draws the CollisionRects
//     	CSGD_Direct3D::GetInstance()->SpriteEnd();
//     	CSGD_Direct3D::GetInstance()->DeviceEnd();
//     	CSGD_Direct3D::GetInstance()->DrawRect(GetCollisionRect(), 255, 255, 255);
//     	CSGD_Direct3D::GetInstance()->DeviceBegin();	
//    	CSGD_Direct3D::GetInstance()->SpriteBegin();
// 	//////////////////////////////////////////////////////////////
}

void CBase::HandleEvent(CEvent* pEvent)
{
}

bool CBase::CheckCollisions(CBase * pBase) 
{ 
	RECT tempRect;

	if(GetType() != OBJECT_PLAYER && GetType() != pBase->GetType() && this != pBase )
	{
		CNote* temp = (CNote*)pBase;

		if( /*!temp->GetIsHit() &&*/ IntersectRect(&tempRect, &GetCollisionRect(), &pBase->GetCollisionRect()))
		{
			//CSGD_MessageSystem::GetInstance()->SendMsg(new CDestroyBulletMessage(this));

			return true;
		}
		
	}

	return false; 
}
